/*------------------------------------------------------------------------*/
/* FILE NAME: WR_MPC5554_ram.ld             COPYRIGHT (c) FREESCALE 2006  */
/*                                                                        */
/* DESCRIPTION:                                                           */
/*    MPC5554 Example WindRiver linker File for RAM only operation.       */
/* ORIGINAL AUTHOR: Randy Dees                                            */
/* REV      AUTHOR       DATE       DESCRIPTION OF CHANGE                 */
/* ---   -----------   ----------   ---------------------                 */
/* 0.1   Randy Dees    25/Mar/04     Initial version.                     */
/* 0.2   G. Jackson    02/Apr/04     Added stack pointers, flash_data     */
/* 0.3   G. Jackson    26/Apr/04     Added OPCOUNT for SRAM load          */
/* 0.4   G. Jackson    13/May/04     Moved .flash_data into int_flash     */
/*                                    Removed ALIGN 0x1000, TEXT, CONST   */
/*                                   Created ramcfg.lcf for pure SRAM run */
/* 0.5   G. Jackson    25/May/04     Changed __SRAM_OPCODE to __SRAM_LOAD */
/*                                   Changed __SRAM_OPCODE_SIZE and       */
/*                                    __OPCOUNT to __SRAM_LOAD_SIZE       */
/* 1.0   G. Jackson    11/Jun/04     Created a heap space used for the    */
/*                                    SRAM load.                          */
/* 1.0b  G. Jackson    15/Nov/04     Added external flash space           */
/* 1.1   Chris Baker   19/Jul/06     Renamed the file and reorganised the */
/*                                   MEMORY group.                        */
/* 1.2   Chris Baker   30/Aug/06     Unified int_sram regions.            */
/* 1.3   Chris Baker   21/Sep/06     Changed stack in cache address.      */
/*------------------------------------------------------------------------*/


MEMORY
{
/* 2M External Flash (unused) */
/* 512K External SRAM (unused) */
        ext_flash : org = 0x20000000, len = 0x00200000
        ext_ram   : org = 0x3ff80000, len = 0x80000

/* Internal SRAM RCW */
/* MPC5554 64K Internal SRAM */
/* MPC5554 4K of internal cache used for stack. */
        sram_rcw  : org = 0x40000000, len = 0x8
        int_sram  : org = 0x40000008, len = 0xFFF8
        stack_ram : org = 0x40040000, len = 0x1000
}


SECTIONS
{

/* ROM data */
    .rcw  : { *(.rcw) } > sram_rcw

    GROUP :
    {
	.init       : { *(.init) }
	.text       : {}
	.flash_data : {}
	.rodata  :
	{
         *(.rdata) 
         *(.rodata) 
	}


	/*These definition only needed for compile time, they will not be used during run-time when executing out of RAM*/
	.= ((. + 7) & ~7); /* align __DATA_ROM to .data start */
         __DATA_ROM =.;
         . = . + SIZEOF(.data); /* make space for .data */
         __SDATA_ROM = .;
         . = . + SIZEOF(.sdata); /* make space for .sdata */
         __DATA_ROM_END = .;  /* end of __DATA_ROM */

	.ctors : {}
	.dtors : {}

	
	/*the interrupt vector table for the INTC must be aligned on 2K boundary*/
	.isrvectbl ALIGN(0x800): {}

	.xcptn: {}  
	extabindex : {}
     } > int_sram



    /* SRAM data */
    GROUP :
    {
	.data   : {}
	.sdata  : {}
	.sbss   : {}
	.sdata2 : {}
	.sbss2  : {}
	.bss    : {}
	.heap   : {}
    } > int_sram

}

/* Stack Address Parameters */
__SP_INIT      = ADDR(stack_ram) + SIZEOF(stack_ram); 
__SP_END       = ADDR(stack_ram); 
__STACK_SIZE   = SIZEOF(stack_ram); 


/* SRAM Address Parameters */
__SRAM_CPY_START = ADDR(.data);
__ROM_COPY_SIZE  = (SIZEOF(.data) + SIZEOF(.sdata));
__SRAM_LOAD      = ADDR(.heap);
__SRAM_LOAD_SIZE = (SIZEOF(.flash_data)/4);

/* Interrupt Handler Parameters */
__IV_ADDR     = ADDR(.xcptn);
